@section('title', 'Tampak Rumah')

<x-admin>
<div class="container">
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h3 class="font-weight-bold">Tampak Rumah</h3>
                <a href="{{ route('admin.tampakrumah.create') }}" class="btn btn-outline-secondary">Tambah Ruangan</a>
            </div>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Jenis Ruangan</th>
                        <th>Visual</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($ruangans as $ruangan)
                    <tr>
                        <td>{{ $ruangan->nama }}</td>
                        <td>
                            @if($ruangan->gambar)
                                <img src="{{ asset('storage/' . $ruangan->gambar) }}" alt="Visual" style="max-width:120px;max-height:120px;border-radius:16px;">
                            @endif
                        </td>
                        <td><a href="{{ route('admin.tampakrumah.edit', $ruangan->id) }}" class="btn btn-primary btn-sm">Lihat/edit</a></td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="3" class="text-center text-muted">Belum ada ruangan yang terdaftar.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
</x-admin> 