@extends('layouts.app')
@section('content')

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Arial', sans-serif;
        line-height: 1.6;
    }

    /* Top Navigation Bar */
    .top-navbar {
        background-color: #1a1a1a;
        padding: 0.3rem 0;
        font-size: 0.8rem;
    }

    .top-navbar .container {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .top-navbar .contact-info {
        color: #ccc;
    }

    .top-navbar .social-links a {
        color: #ccc;
        margin-left: 1rem;
        font-size: 0.9rem;
    }

    /* Main Navigation */
    .main-navbar {
        background-color: #ffffff;
        padding: 1rem 0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .navbar-brand {
        color: #4CAF50 !important;
        font-weight: bold;
        font-size: 1.1rem;
        display: flex;
        align-items: center;
    }

    .navbar-brand i {
        color: #4CAF50;
        margin-right: 8px;
        font-size: 1.2rem;
    }

    .main-navbar .navbar-nav {
        margin: 0 auto;
    }

    .main-navbar .navbar-nav .nav-link {
        color: #333 !important;
        margin: 0 1.5rem;
        font-size: 0.95rem;
        font-weight: 500;
        padding: 0.5rem 0;
    }

    .main-navbar .navbar-nav .nav-link:hover {
        color: #4CAF50 !important;
    }

    .btn-hubungi {
        background-color: #ff5722;
        color: white;
        border: none;
        padding: 0.6rem 1.8rem;
        border-radius: 25px;
        font-size: 0.9rem;
        font-weight: 600;
    }

    .btn-hubungi:hover {
        background-color: #e64a19;
        color: white;
    }

    /* Hero Section */
    .hero-section {
        background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), 
                    url('/placeholder.svg?height=500&width=1200');
        background-size: cover;
        background-position: center;
        color: white;
        padding: 5rem 0;
        min-height: 500px;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
    }

    .hero-content h1 {
        font-size: 3.5rem;
        font-weight: 700;
        margin-bottom: 1rem;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
    }

    .hero-content p {
        font-size: 1.3rem;
        font-weight: 400;
        text-shadow: 1px 1px 2px rgba(0,0,0,0.5);
    }

    /* Booking Section */
    .booking-section {
        padding: 4rem 0;
        background-color: #f8f9fa;
    }

    .booking-header {
        text-align: center;
        margin-bottom: 3rem;
    }

    .booking-label {
        color: #ff5722;
        font-size: 1.1rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
    }

    .booking-title {
        color: #333;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .house-booking-card {
        background: white;
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        max-width: 350px;
        margin: 0 auto;
    }

    .house-booking-image {
        width: 100%;
        height: 200px;
        background: linear-gradient(135deg, #e3f2fd, #bbdefb);
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        margin-bottom: 1rem;
    }

    .house-booking-image::before {
        content: '';
        position: absolute;
        width: 120px;
        height: 80px;
        background: #90a4ae;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }

    .house-booking-body {
        padding: 2rem;
        text-align: center;
    }

    .house-booking-type {
        font-size: 1.3rem;
        font-weight: 700;
        color: #333;
        margin-bottom: 1rem;
    }

    .house-booking-price {
        font-size: 1.1rem;
        font-weight: 600;
        color: #4CAF50;
        margin-bottom: 1.5rem;
    }

    .house-booking-specs {
        display: flex;
        justify-content: space-around;
        margin-bottom: 2rem;
        font-size: 0.9rem;
    }

    .spec-item {
        text-align: center;
    }

    .spec-icon {
        font-size: 1.2rem;
        color: #666;
        margin-bottom: 0.3rem;
    }

    .spec-label {
        color: #666;
        font-size: 0.8rem;
    }

    .spec-value {
        color: #333;
        font-weight: 600;
        font-size: 0.9rem;
    }

    .btn-booking-now {
        background-color: #2196f3;
        color: white;
        border: none;
        padding: 0.8rem 2rem;
        border-radius: 25px;
        font-weight: 600;
        width: 100%;
    }

    /* Detail Section */
    .detail-section {
        background-color: #e8f5e8;
        padding: 4rem 0;
    }

    .detail-header {
        text-align: center;
        margin-bottom: 3rem;
    }

    .detail-label {
        color: #666;
        font-size: 1rem;
        margin-bottom: 0.5rem;
    }

    .detail-title {
        color: #333;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .image-carousel {
        position: relative;
        max-width: 800px;
        margin: 0 auto;
    }

    .carousel-container {
        display: flex;
        overflow: hidden;
        border-radius: 15px;
        /* box-shadow: 0 8px 25px rgba(0,0,0,0.15); */
    }

    .carousel-slide {
        min-width: 100%;
        transition: transform 0.3s ease;
    }

    .carousel-image {
        width: 100%;
        height: 400px;
        background: linear-gradient(135deg, #f5f5f5, #e0e0e0);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.2rem;
        color: #666;
        font-weight: 600;
    }

    .carousel-nav {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        background: rgba(255,255,255,0.9);
        border: none;
        width: 50px;
        height: 50px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.2rem;
        color: #333;
        cursor: pointer;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    .carousel-nav.prev {
        left: 20px;
    }

    .carousel-nav.next {
        right: 20px;
    }

    .carousel-indicator {
        text-align: center;
        margin-top: 2rem;
    }

    .indicator-label {
        background: rgba(0,0,0,0.8);
        color: white;
        padding: 0.5rem 1rem;
        border-radius: 20px;
        font-size: 0.9rem;
        font-weight: 600;
    }

    /* Benefits Section */
    .benefits-section {
        background-color: #1a1a1a;
        color: white;
        padding: 4rem 0;
    }

    .benefits-header {
        text-align: center;
        margin-bottom: 3rem;
    }

    .benefits-question {
        color: #4CAF50;
        font-size: 1.1rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
    }

    .benefits-title {
        color: white;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .benefits-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 2rem;
        margin-top: 3rem;
    }

    .benefit-item {
        text-align: center;
        padding: 2rem 1rem;
    }

    .benefit-icon {
        width: 80px;
        height: 80px;
        margin: 0 auto 1.5rem;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2rem;
    }

    .benefit-icon.health {
        background-color: #f44336;
        color: white;
    }

    .benefit-icon.school {
        background-color: #2196f3;
        color: white;
    }

    .benefit-icon.gas {
        background-color: #ff9800;
        color: white;
    }

    .benefit-icon.office {
        background-color: #ff5722;
        color: white;
    }

    .benefit-icon.transport {
        background-color: #4CAF50;
        color: white;
    }

    .benefit-icon.airport {
        background-color: #2196f3;
        color: white;
    }

    .benefit-icon.toll {
        background-color: #ffeb3b;
        color: #333;
    }

    .benefit-title {
        font-size: 1.1rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
        color: white;
    }

    .benefit-desc {
        font-size: 0.9rem;
        color: #ccc;
        line-height: 1.5;
    }

    /* Special Offer Section */
    .special-offer-section {
        padding: 4rem 0;
        background-color: white;
    }

    .offer-title {
        font-size: 2.2rem;
        font-weight: 700;
        color: #4CAF50;
        margin-bottom: 0.5rem;
    }

    .offer-subtitle {
        font-size: 2.2rem;
        font-weight: 700;
        color: #333;
        margin-bottom: 2rem;
    }

    .promo-features {
        margin: 2rem 0;
    }

    .feature-item {
        display: flex;
        align-items: center;
        margin-bottom: 0.8rem;
    }

    .feature-item i {
        color: #4CAF50;
        margin-right: 0.8rem;
        font-size: 1.1rem;
    }

    .feature-item span {
        font-size: 0.95rem;
        color: #333;
    }

    .discount-banner {
        background: linear-gradient(135deg, #ff5722, #ff7043);
        color: white;
        padding: 2rem;
        border-radius: 15px;
        text-align: center;
        margin-bottom: 2rem;
        position: relative;
        overflow: hidden;
    }

    .discount-title {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }

    .discount-amount {
        font-size: 3rem;
        font-weight: 900;
        margin-bottom: 0.5rem;
    }

    .discount-note {
        font-size: 1rem;
        opacity: 0.9;
    }

    .offer-image {
        width: 100%;
        border-radius: 10px;
        /* box-shadow: 0 6px 20px rgba(0,0,0,0.1); */
        max-height: 512px;
        object-fit: contain;
    }

    /* Footer */
    .footer {
        background-color: #1a1a1a;
        color: #ccc;
        padding: 3rem 0 1rem;
    }

    .footer h5 {
        color: #4CAF50;
        font-size: 1.2rem;
        font-weight: 700;
        margin-bottom: 1.5rem;
    }

    .footer p, .footer li {
        font-size: 0.9rem;
        line-height: 1.6;
        margin-bottom: 0.5rem;
    }

    .footer a {
        color: #ccc;
        text-decoration: none;
    }

    .footer a:hover {
        color: #4CAF50;
    }

    .footer .social-icons a {
        color: #4CAF50;
        font-size: 1.5rem;
        margin-right: 1rem;
    }

    .footer-bottom {
        border-top: 1px solid #333;
        margin-top: 2rem;
        padding-top: 1rem;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .hero-content h1 {
            font-size: 2.5rem;
        }
        
        .booking-title {
            font-size: 1.8rem;
        }
        
        .detail-title {
            font-size: 1.8rem;
        }
        
        .benefits-title {
            font-size: 1.8rem;
        }
        
        .benefits-grid {
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1.5rem;
        }
        
        .carousel-nav {
            width: 40px;
            height: 40px;
            font-size: 1rem;
        }
        
        .carousel-nav.prev {
            left: 10px;
        }
        
        .carousel-nav.next {
            right: 10px;
        }
    }
</style>

<!-- Hero Section -->
<section class="hero-section" style="background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('{{ asset('hero1.png') }}'); background-size: cover; background-position: center; color: white; padding: 5rem 0; min-height: 500px; display: flex; align-items: center; justify-content: center; text-align: center;">
    <div class="container">
        <div class="hero-content">
            <h1>Type 36</h1>
            <p>Hunian modern, nyaman, dan strategis untuk keluarga Anda.</p>
        </div>
    </div>
</section>

<!-- Booking Section -->
<section class="booking-section">
    <div class="container">
        <div class="booking-header">
            <p class="booking-label">Booking 1 Juta All In</p>
            <h2 class="booking-title">Pilih Rumah Impianmu</h2>
        </div>
        
        <div class="row justify-content-center">
            <div class="col-lg-4">
                <div class="house-booking-card">
                    <div class="house-booking-image"><img src="{{ asset('rumah1.png') }}" alt="Rumah" style="width:100%;height:auto;object-fit:cover;"></div>
                    <div class="house-booking-body">
                        <h3 class="house-booking-type">Type 36/102</h3>
                        <p class="house-booking-price">Rp 2 Jutaan</p>
                        <div class="house-booking-specs">
                            <div class="spec-item">
                                <div class="spec-icon"><i class="fas fa-home"></i></div>
                                <div class="spec-label">Luas Bangunan</div>
                                <div class="spec-value">36 m²</div>
                            </div>
                            <div class="spec-item">
                                <div class="spec-icon"><i class="fas fa-expand-arrows-alt"></i></div>
                                <div class="spec-label">Luas Tanah</div>
                                <div class="spec-value">102 m²</div>
                            </div>
                            <div class="spec-item">
                                <div class="spec-icon"><i class="fas fa-bed"></i></div>
                                <div class="spec-label">Kamar Tidur</div>
                                <div class="spec-value">2</div>
                            </div>
                            <div class="spec-item">
                                <div class="spec-icon"><i class="fas fa-bath"></i></div>
                                <div class="spec-label">Kamar Mandi</div>
                                <div class="spec-value">1</div>
                            </div>
                        </div>
                        <a href="kontak" class="btn btn-booking-now">Tanya Detail</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Detail Section -->
<section class="detail-section">
    <div class="container">
        <div class="detail-header">
            <p class="detail-label" style="font-weight: bold; font-size: 1.5rem; color: #577B53;">Detail Rumah Type 36</p>
            <h2 class="detail-title">Rumah Ternyaman Dengan Fasilitas Lengkap</h2>
        </div>
        
        <div class="image-carousel">
            <div class="carousel-container row justify-content-center align-items-center">
                <div class="col-md-4">
                    <div class="carousel-slide">
                        <img src="{{ asset('tipe36-1.png') }}" alt="Interior 1" class="img-fluid rounded shadow" style="width:100%;height:250px;object-fit:cover;">
                        <div class="text-center mt-3" style="font-weight:500; color:#000;">Dapur</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="carousel-slide">
                        <img src="{{ asset('tipe36-2.png') }}" alt="Interior 2" class="img-fluid rounded shadow" style="width:100%;height:250px;object-fit:cover;">
                        <div class="text-center mt-3" style="font-weight:500; color:#000;">Kamar Tidur</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="carousel-slide">
                        <img src="{{ asset('tipe36-3.png') }}" alt="Interior 3" class="img-fluid rounded shadow" style="width:100%;height:250px;object-fit:cover;">
                        <div class="text-center mt-3" style="font-weight:500; color:#000;">Ruang Tamu</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Benefits Section -->
<section class="benefits-section">
    <div class="container">
        <div class="benefits-header">
            <p class="benefits-question">Kenapa Harus di Maskarebat Green Garden ?</p>
            <h2 class="benefits-title">Karena Banyak Untungnya</h2>
        </div>
        
        <div class="benefits-grid">
            <div class="benefit-item">
                <div class="benefit-icon health">
                    <i class="fas fa-hospital"></i>
                </div>
                <h4 class="benefit-title">Fasilitas Kesehatan</h4>
                <p class="benefit-desc">Akses mudah menuju rumah sakit dan puskesmas untuk kebutuhan kesehatan keluarga</p>
            </div>
            
            <div class="benefit-item">
                <div class="benefit-icon school">
                    <i class="fas fa-graduation-cap"></i>
                </div>
                <h4 class="benefit-title">Dekat Sekolah</h4>
                <p class="benefit-desc">Berdekatan dengan sekolah berkualitas dari tingkat dasar hingga menengah</p>
            </div>
            
            <div class="benefit-item">
                <div class="benefit-icon gas">
                    <i class="fas fa-gas-pump"></i>
                </div>
                <h4 class="benefit-title">SPBU</h4>
                <p class="benefit-desc">Stasiun pengisian bahan bakar umum terdekat untuk kemudahan transportasi</p>
            </div>
            
            <div class="benefit-item">
                <div class="benefit-icon office">
                    <i class="fas fa-building"></i>
                </div>
                <h4 class="benefit-title">Pusat Perkantoran</h4>
                <p class="benefit-desc">Lokasi strategis dekat dengan pusat bisnis dan perkantoran</p>
            </div>
            
            <div class="benefit-item">
                <div class="benefit-icon transport">
                    <i class="fas fa-bus"></i>
                </div>
                <h4 class="benefit-title">Akses Angkutan Umum</h4>
                <p class="benefit-desc">Akses ke transportasi umum yang memudahkan mobilitas sehari-hari</p>
            </div>
            
            <div class="benefit-item">
                <div class="benefit-icon airport">
                    <i class="fas fa-plane"></i>
                </div>
                <h4 class="benefit-title">Dekat Bandara</h4>
                <p class="benefit-desc">Lokasi strategis dekat dengan bandara untuk kemudahan perjalanan</p>
            </div>
            
            <div class="benefit-item">
                <div class="benefit-icon toll">
                    <i class="fas fa-road"></i>
                </div>
                <h4 class="benefit-title">Akses ke Tol</h4>
                <p class="benefit-desc">Akses mudah menuju jalan tol untuk perjalanan antar kota</p>
            </div>
        </div>
    </div>
</section>

<!-- Special Offer Section -->
<section class="special-offer-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h2 class="offer-title">Dapatkan Sekarang</h2>
                <h3 class="offer-subtitle">Sebelum Harga Naik !</h3>
                
                <button class="btn btn-primary mb-3">Booking Sekarang</button>
                <p><strong>Promo Terbatas Ini!</strong></p>
                <p class="mb-4">Dapatkan Promo, Booking cuman 1 Jt bisa dapetin rumah impian!</p>
                
                <div class="promo-features">
                    <div class="row">
                        <div class="col-6">
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Tanpa DP</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Gratis Biaya Pajak</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Air Conditioner (AC)</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Gratis SHM</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>TV 32 Inch</span>
                            </div>
                            <div class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Subsidi Angsuran 1 tahun</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <button class="btn btn-hubungi btn-lg mt-3">Hubungi Kami</button>
            </div>
            <div class="col-lg-6">
                <!-- <div class="discount-banner">
                    <div class="discount-title">DISKON SPESIAL</div>
                    <div class="discount-amount">110 JUTA</div>
                    <div class="discount-note">Berlaku sampai 31 Desember 2024</div>
                </div> -->
                <img src="{{ asset('diskon.png') }}" alt="Special Offer House" class="offer-image">
            </div>
        </div>
    </div>
</section>

@endsection 

@push('scripts')
<script>
    // Simple carousel functionality
    let currentSlide = 0;
    const slides = ['Dapur', 'Kamar Tidur', 'Ruang Tamu'];
    
    function updateIndicator() {
        document.querySelector('.indicator-label').textContent = slides[currentSlide];
    }
    
    function nextSlide() {
        currentSlide = (currentSlide + 1) % slides.length;
        updateIndicator();
    }
    
    function prevSlide() {
        currentSlide = (currentSlide - 1 + slides.length) % slides.length;
        updateIndicator();
    }
</script>
@endpush