<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Maskarebat Green Garden</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body, html {
            font-family: 'Poppins', Arial, sans-serif !important;
        }
    </style>
</head>
<body>
    <!-- Top Navigation -->
    <div class="top-navbar">
        <div class="container">
            <div class="contact-info">
                <i class="fas fa-phone me-2"></i>0895-7058-8521
                <span class="ms-3"><i class="fas fa-envelope me-2"></i>info@maskarebetgreengarden.my.id</span>
            </div>
            <div class="social-links">
                <a href="#"><i class="fab fa-facebook"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
                <a href="#"><i class="fab fa-whatsapp"></i></a>
            </div>
        </div>
    </div>

    <!-- Main Navigation -->
    <nav class="navbar navbar-expand-lg main-navbar">
        <div class="container">
            <a class="navbar-brand" href="#">
                <img style="width: 150px;" src="{{ asset('logo-fe.png') }}" alt="Maskarebat Green Garden" >
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" style="border: none;">
                <span style="color: #333;"><i class="fas fa-bars"></i></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" href="/"><strong>Home</strong></a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="typeDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <strong>Type</strong>
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="typeDropdown">
                            <li><a class="dropdown-item" href="/type-36"><strong>Tipe 36</strong></a></li>
                            <li><a class="dropdown-item" href="/type-54"><strong>Tipe 54</strong></a></li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/simulasi-kpr"><strong>Simulasi KPR</strong></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/karir"><strong>Karir</strong></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/kontak"><strong>Kontak</strong></a>
                    </li>
                </ul>
                <button class="btn btn-hubungi ms-auto"><strong>Hubungi Kami</strong></button>
            </div>
        </div>
    </nav>

    <div class="main-content">
        @yield('content')
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    @stack('scripts')

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <h5><i class="fas fa-home me-2"></i>MASKAREBAT Green Garden</h5>
                    <p>Perumahan Maskarebat Green Garden menawarkan hunian modern dengan konsep ramah lingkungan di lokasi strategis Palembang. Investasi terbaik untuk masa depan keluarga Anda dengan fasilitas lengkap dan akses mudah ke berbagai tempat penting.</p>
                    <div class="social-icons mt-3">
                        <a href="#"><i class="fab fa-facebook"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                        <a href="#"><i class="fab fa-tiktok"></i></a>
                    </div>
                </div>
                <div class="col-lg-4">
                    <h5>Tentang Kami</h5>
                    <ul class="list-unstyled">
                        <li><a href="#">Promo Berakhir</a></li>
                        <li><a href="#">Kavling Dijual</a></li>
                        <li><a href="#">Tentang Kami</a></li>
                        <li><a href="#">Kontak</a></li>
                        <li><a href="#">Type 36</a></li>
                    </ul>
                    <h5 class="mt-4">Untuk Anda</h5>
                </div>
                <div class="col-lg-4">
                    <h5>Kontak Kami</h5>
                    <p><i class="fas fa-map-marker-alt me-2"></i>Jl. Srijaya Negara, Kec. Talang Kelapa, Kabupaten Banyuasin, Sumatera Selatan</p>
                    <p><i class="fas fa-clock me-2"></i>08:00 - 17:00 WIB</p>
                    <p><i class="fas fa-phone me-2"></i>0895 - 7058 - 8521</p>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="row">
                    <div class="col-md-6">
                        <p>&copy; 2025 Maskarebat Green Garden. All rights reserved.</p>
                    </div>
                    <div class="col-md-6 text-end">
                        <p>Syarat Penggunaan | Kebijakan Privasi</p>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</body>
</html>